<?php
/*
// JS/CSS spécifiques au slider
wp_enqueue_script( 'bridge-jui-slider', BridgeUtils::bridgeDirUrl() . 'public/bridgewebfrontlibs/js/jui/jquery-ui.slider.min.js', array('jquery'), null, true);
wp_enqueue_style('bridge-jui-slider', BridgeUtils::bridgeDirUrl() . 'public/bridgewebfrontlibs/css/jui/jquery-ui.slider.min.css');
*/
// Vérification du bon paramétrage du filtre
$isOK = true;
if(!isset($filter->items) || count($filter->items) <= 0)
{
	$isOK    = false;
	$message = 'Veuillez définir un élément dans le filtre et indiquer un minimum et un maximum';
}

$item = $filter->items[0];
if($item->min == '' || $item->max == '' || $item->interval == '')
{
	$isOK    = false;
	$message = 'Veuillez indiquer un minimum, un maximum et un intervalle dans l\'élément de filtre';
}

if(!isset($item->params) || !isset($item->params->criterionCode) || $item->params->criterionCode == '')
{
	$isOK    = false;
	$message = 'Veuillez indiquer un critère dans l\'élément de filtre';
}

// Valeurs par défaut
$min = $item->min;
$max = $item->max;
?>

<?php if(!$isOK): ?>
	<p>
		<b>Erreur d'affichage du filtre</b><br/>
		<?= $message ?>
	</p>
<?php else: ?>

    <?php include dirname(__FILE__) . '/common/filter-header.php' ; ?>

	<?php if(isset($item->label) && $item->label != ''): ?>
		<h4>
			<?= $item->label ?>
		</h4>
	<?php endif; ?>


	<div id="bridge_filter_<?= $moteur->id ?>-<?= $filter->id ?>" class=""></div>

	<div>
		Min : <span id="bridge_min_<?= $moteur->id ?>-<?= $filter->id ?>"><?= $min ?></span>
		Max : <span id="bridge_max_<?= $moteur->id ?>-<?= $filter->id ?>"><?= $max ?></span>
	</div>

<script type="text/javascript">
    // <!--
	bridgeDocumentReady(function() {
	    var lemin = <?= $item->min ?>;
	    var lemax = <?= $item->max ?>;
        var tmpFilter = window.bridgeMoteur<?= $moteur->id ?>.getFilter(<?= $filter->id ?>);
	    if( tmpFilter != false && tmpFilter.min && tmpFilter.min != '') {
            tmpFilter.min = parseInt(tmpFilter.min);
	        lemin = tmpFilter.min;
		}
        if( tmpFilter != false && tmpFilter.max && tmpFilter.max != '') {
            tmpFilter.max = parseInt(tmpFilter.max);
            lemax = tmpFilter.max;
        }
        jQuery("#bridge_min_<?= $moteur->id ?>-<?= $filter->id ?>").html(lemin);
        jQuery("#bridge_max_<?= $moteur->id ?>-<?= $filter->id ?>").html(lemax);


        jQuery( "#bridge_filter_<?= $moteur->id ?>-<?= $filter->id ?>" ).slider({
            orientation: 'horizontal',
            range: true,
            min: <?= $item->min ?>,
            max: <?= $item->max ?>,
            step: <?= $item->interval ?>,
            values: [ lemin, lemax ],
            change: function( event, ui ) {
                min = ui.values[0];
                max = ui.values[1];

                jQuery("#bridge_min_<?= $moteur->id ?>-<?= $filter->id ?>").html(min);
                jQuery("#bridge_max_<?= $moteur->id ?>-<?= $filter->id ?>").html(max);

                window.bridgeMoteur<?= $moteur->id ?>.setItemProp(<?= $filter->id ?>, <?= $item->id ?>, 'min', min);
                window.bridgeMoteur<?= $moteur->id ?>.setItemProp(<?= $filter->id ?>, <?= $item->id ?>, 'max', max);
            }
        }) ;
	});
    // -->
</script>
<?php // print_r($filter); ?>
<?php endif; ?>
